//precision highp float;

uniform vec2 u_foregroundCellSize; //foreground
uniform vec2 u_textureSize; //foreground
uniform vec2 u_cellSize; //in the main texture
uniform vec2 u_gridUVSize;

varying vec2 v_texCoord;
varying vec2 v_cellTexCoord;

void main()
{
    vec2 snappedCellTexCoord = (floor(v_texCoord / u_cellSize ) + 0.5 ) * u_cellSize * u_gridUVSize;
    vec4 cellAtt = texture2D(CC_Texture2, snappedCellTexCoord);
    vec4 particleUvs = texture2D(CC_Texture1, snappedCellTexCoord);
    
    vec4 finalColor = vec4(0.0);
    
    float noMask = step(0.001, cellAtt.a);          // 0 -> commonParticle
    float fullMask = 1.0 - step(0.7, cellAtt.a);    	// 0 -> water
    float middleMask = noMask * fullMask;           // 1 -> foreground particle
    
    if ( particleUvs != vec4(0.0)){ //foreground
        //Sample particle coordinate
        float x = floor(particleUvs.r * 65025.0 + particleUvs.g * 254.7 + 0.5);
        float y = floor(particleUvs.b * 65025.0 + particleUvs.a * 254.7 + 0.5);
        vec2  samplePoint;
        samplePoint.x = x / u_textureSize.x;
        samplePoint.y = y / u_textureSize.y;
        
        //should add the offset
        vec2 cellUVOffset= mod (v_texCoord, u_cellSize) * u_foregroundCellSize;
        
        finalColor = texture2D(CC_Texture3, samplePoint + cellUVOffset );
    }
    
    gl_FragColor = finalColor;
}
